//
//  GSUserNotification.h
//  GlyphsKit
//
//  Created by Georg Seifert on 28.07.24.
//  Copyright © 2024 schriftgestaltung.de. All rights reserved.
//

#import <Foundation/Foundation.h>

@protocol GSUserNotificationDelegate

@end

NS_ASSUME_NONNULL_BEGIN

@interface GSUserNotification : NSObject

// -----------------------
// These properties are used to configure the notification before it is scheduled.

// The title of the notification. Must be localized as it will be presented to the user. String will be truncated to a length appropriate for display.
@property (nullable, copy) NSString *title;

// The subtitle displayed in the notification. Must be localized as it will be presented to the user. String will be truncated to a length appropriate for display.
@property (nullable, copy) NSString *subtitle;

// The body of the notification. Must be localized as it will be presented to the user. String will be truncated to a length appropriate for display.
@property (nullable, copy) NSString *informativeText;

// The title of the button displayed in the notification. Must be localized as it will be presented to the user. String will be truncated to a length appropriate for display.
@property (copy) NSString *actionButtonTitle;

// Application-specific user info that may be retrieved later. All items must be property list types or an exception will be thrown. The userInfo should be of reasonable serialized size or an exception will be thrown.
@property (nullable, copy) NSDictionary<NSString *, id> *userInfo;

- (void)deliver;

+ (void)setDelegate:(id <GSUserNotificationDelegate>)delegate;

@end

NS_ASSUME_NONNULL_END
